﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Collections.Generic" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie umow dla pracownika</title>
		<script runat="server">

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            okres = FromTo.Year(data.Year);
        }
    
        FromTo okres;
        [Required]
        [Priority(1)]
        [Caption("Zestawienie za okres")]
        public FromTo Okres {
            get { return okres; }
            set {
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool anulowane = true;
        [Priority(2)]
        [Caption("Umowy anulowane")]
        public bool Anulowane {
            get { return anulowane; }
            set {
                anulowane = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
    
    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool szczegolowo = false;
        [Caption("Szczegółowo")]
        public bool Szczegolowo {
            get { return szczegolowo; }
            set {
                szczegolowo = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		

    class Total: IComparable {
        readonly YearMonth miesiąc;
        Umowa umowa;
        decimal brutto;
        decimal składki;
        decimal podatek;
        decimal zdrowotne;
        decimal netto;
        public Total(YearMonth miesiąc, Umowa umowa) {
            this.miesiąc = miesiąc;
            this.umowa = umowa;
            brutto = składki = podatek = zdrowotne = netto = 0;
        }
        public void Add(Umowa um) {
            UmowaHistoria hist = um[miesiąc.LastDay];
            UmowaPodatkiWorker worker = new UmowaPodatkiWorker(hist);
            brutto += worker.Wartość;
            składki += worker.SkładkiZUS;
            podatek += worker.Podatek;
            zdrowotne += worker.SkładkiZdrow;
            netto += worker.DoWypłaty;
        }
        public string Umowa {
            get { return umowa.Numer.NumerPelny; }
        }
        public DefinicjaElementu Element {
            get { return umowa.Element; }
        }
        public StanUmowy Stan {
            get { return umowa.Stan; }
        }
        public YearMonth Miesiąc {
            get { return miesiąc; }
        }
        public decimal Brutto {
            get { return brutto; }
        }
        public decimal Składki {
            get { return składki; }
        }
        public decimal Podatek {
            get { return podatek; }
        }
        public decimal Zdrowotne {
            get { return zdrowotne; }
        }
        public decimal Netto {
            get { return netto; }
        }
        public int CompareTo(object obj) {
            if (obj==null)
                return 1;
            return miesiąc.CompareTo(((Total)obj).Miesiąc);
        }
    }
    
    void dc_ContextLoad(Object sender, EventArgs e) {
        PracHistoria historia = (PracHistoria)dc[typeof(PracHistoria)];
        ReportHeader["KTO"] = historia.Pracownik.ImięNazwisko;
        ReportHeader["OKRES"] = pars.Okres.ToString();

        colUmowa.Visible = colElement.Visible = srpars.Szczegolowo;
        colMiesiąc.Visible = !srpars.Szczegolowo;
        if (srpars.Szczegolowo) {
            Grid1.GroupLine = "{0}";
            Grid1.GroupData0 = "Miesiąc";
            Grid1.ShowGroupSum = true;
            colUmowa.Total = Soneta.Web.Total.Info;
        }
        else
            colMiesiąc.Total = Soneta.Web.Total.Info;

        List<Total> ht = new List<Total>();
        foreach (Umowa umowa in historia.Pracownik.Umowy)
            if (umowa.Okres.IsIntersected(pars.Okres) && (pars.Anulowane || !umowa.Anulowana)) {
                YearMonth ym = new YearMonth(umowa.Okres.From);
                Total t = ht.Find(x => x.Miesiąc==ym && (srpars.Szczegolowo || x.Stan==umowa.Stan));
                if (t==null || srpars.Szczegolowo) {
                    t = new Total(ym, umowa);
                    ht.Add(t);
                }
                t.Add(umowa);
            }
    
        ht.Sort();
        Grid1.DataSource = ht;
    }
    
    static void Msg(object obj) {
    }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad" TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie zawartych umów cywilno-prawnych|</strong>Dla: <strong>%KTO%|</strong>Za okres: <strong>%OKRES%|</strong>Dane pobrane z wartości zasymulowanych na formularzu umowy"
				runat="server"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server">
				<Columns>
					<ea:GridColumn Align="Right" ID="colUmowa" Width="20" DataMember="Umowa" Caption="Umowa"></ea:GridColumn>
					<ea:GridColumn Align="Right" ID="colElement" Width="20" DataMember="Element" Caption="Element"></ea:GridColumn>
					<ea:GridColumn Align="Right" ID="colMiesiąc" DataMember="Miesiąc" Caption="Miesiąc"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Stan" Width="15" Caption="Stan umowy"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Brutto" Total="Sum" Caption="Brutto" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Składki" Total="Sum" Caption="Składki" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Podatek" Total="Sum" Caption="Podatek" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Zdrowotne" Total="Sum" Caption="Zdrowotne" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Netto" Total="Sum" Caption="Netto" Format="{0:n}"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server">
				<Subtitles>
					<eb:FooterSubtitle SubtitleType="Empty" Width="50"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Podpis osoby odpowiedzialnej za przygotowanie zestawienia" Width="50"></eb:FooterSubtitle>
				</Subtitles>
			</eb:ReportFooter>
		</form>
	</body>
</HTML>
